/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : menu.h
    Description  : Menu handling functions
    Date         : 15th June 2010
    Version      : v1.00
    Changelog    : v1.00 Initial
*/

// Function pointers
typedef void    (*pfMenuActionFunc)     (void);
typedef boolean (*pfMenuBackgroundFunc) (void);

/*! \struct TyMenuItem Defines a single entry in a menu */
typedef struct
{
   const char *         pszMenuText;    /*!< Menu text to display */
   pfMenuActionFunc     MenuActionFunc; /*!< Function to call if the menu item is selected */
}  TyMenuItem;

// Prototypes
void DoMenu(const char * pMenuText, TyMenuItem *pMenu,boolean bTopLevel,pfMenuBackgroundFunc BkgrndFunc);






